<?php
if (isset($_GET['_id']) && $_GET['_id'] != '') {
  // Ambil dan amankan nilai _id dari URL
  $_id = htmlspecialchars($_GET['_id'], ENT_QUOTES);
  ?>
  <!DOCTYPE html>
  <html ⚡ lang="id" itemscope="itemscope" itemtype="https://schema.org/WebPage">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1">
    <title><?php echo strtoupper($_id); ?> - Akses Resmi Situs Online E-Coops-Day Jurnal Ilmiah Abdimas</title>
    <meta name="description" content="<?php echo strtoupper($_id); ?> hadir sebagai portal resmi E-Coops-Day yang menyajikan informasi penelitian, kegiatan Abdimas, dan update hiburan digital termasuk tren game slot populer.">
    <link rel="canonical" href="https://journal.ikopin.ac.id/public/journals/abdimas/?_id=<?php echo urlencode($_id); ?>">
    <meta property="og:url" content="https://journal.ikopin.ac.id/public/journals/abdimas/?_id=<?php echo urlencode($_id); ?>">
    <meta property="og:image" content="https://pub-400d5e420ec84b259d79304e5888a57e.r2.dev/fafa828-anti-rungkad.png">
    <meta name="robots" content="index, follow" />
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link rel="icon" type="image/png" href="https://majuterus-d40.pages.dev/fafa828-icon.png" sizes="96x96" />
    <link rel="icon" type="image/svg+xml" href="https://majuterus-d40.pages.dev/fafa828-icon.png" />
    <script async src="https://cdn.ampproject.org/v0.js"></script>
    <style amp-boilerplate="">
      body {
        -webkit-animation: -amp-start 8s steps(1, end) 0s 1 normal both;
        -moz-animation: -amp-start 8s steps(1, end) 0s 1 normal both;
        -ms-animation: -amp-start 8s steps(1, end) 0s 1 normal both;
        animation: -amp-start 8s steps(1, end) 0s 1 normal both
      }

      @-webkit-keyframes -amp-start {
        from {
          visibility: hidden
        }

        to {
          visibility: visible
        }
      }

      @-moz-keyframes -amp-start {
        from {
          visibility: hidden
        }

        to {
          visibility: visible
        }
      }

      @-ms-keyframes -amp-start {
        from {
          visibility: hidden
        }

        to {
          visibility: visible
        }
      }

      @-o-keyframes -amp-start {
        from {
          visibility: hidden
        }

        to {
          visibility: visible
        }
      }

      @keyframes -amp-start {
        from {
          visibility: hidden
        }

        to {
          visibility: visible
        }
      }
    </style>
    <noscript>
      <style amp-boilerplate="">
        body {
          -webkit-animation: none;
          -moz-animation: none;
          -ms-animation: none;
          animation: none
        }
      </style>
    </noscript>

    <style amp-custom>
      * {
        box-sizing: border-box;
        margin: 0;
        padding: 0;
      }

      html {
        max-width: 500px;
        margin: 0 auto;
        background: url("https://pub-400d5e420ec84b259d79304e5888a57e.r2.dev/infini88/bg.png") center/cover fixed no-repeat;
      }

      body {
        color: #ffffff;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        text-align: center;
      }

      a, a:hover, a:visited {
        text-decoration: none;
        color: #dfdfdf;
      }

      .atas {
        display: grid;
        min-height: 85vh;
        place-items: center;
      }

      .atasbox {
        margin: auto;
        width: 100%;
        padding: 10px;
      }

      /* Gambar utama */
      .imghero {
        display: block;
        width: 100%;
        max-width: 480px;
        height: auto;
        border-radius: 10px;
        border: 2px solid #ffe600;
        margin: 1rem auto;
        object-fit: cover;
        opacity: 0;
        animation: fadeInUp 1.5s ease-out forwards;
      }

      /* Animasi fade-in */
      @keyframes fadeInUp {
        from { opacity: 0; transform: translateY(40px); }
        to { opacity: 1; transform: translateY(0); }
      }

      /* Tombol */
      .ataslink {
        display: grid;
        grid-template-columns: 1fr;
        gap: 14px;
        width: 100%;
        max-width: 480px;
        margin: 1rem auto;
        padding: 0 10px;
        opacity: 0;
        animation: slideUp 2s ease-out 0.5s forwards;
      }

      @keyframes slideUp {
        from { opacity: 0; transform: translateY(50px); }
        to { opacity: 1; transform: translateY(0); }
      }

      .ataslink a {
        color: #ffffff;
        font-size: 0.95em;
        font-weight: bold;
        text-transform: uppercase;
        padding: 14px 25px;
        border-radius: 25px;
        border: 3px double transparent;
        background-image: linear-gradient(#ff0000, #750000),
        radial-gradient(circle at left top, #ffcc00, #ffcc00);
        background-origin: border-box;
        background-clip: padding-box, border-box;
        transition: 0.4s all;
        display: block;
        width: 100%;
      }

      .ataslink a:hover {
        color: #faff00;
        background-image: linear-gradient(#670606, #c81717),
        radial-gradient(circle at left top, #ffe600, #ffe600);
        transform: scale(1.05);
      }

      /* Efek detak teks */
      #debar {
        animation: beat 2s ease-in-out infinite;
      }

      @keyframes beat {
        0%, 50%, 100% { transform: scale(1); }
        25%, 75% { transform: scale(0.95); }
      }

      /* Footer */
      .footer {
        font-size: 0.8em;
        color: #eee;
        margin-top: 20px;
        opacity: 0;
        animation: fadeIn 3s ease-out 1.5s forwards;
      }

      @keyframes fadeIn {
        from { opacity: 0; }
        to { opacity: 1; }
      }

      /* Responsif */
      @media (max-width: 480px) {
        html { max-width: 100%; }
        .ataslink a { font-size: 0.85em; padding: 12px 20px; }
        .imghero { max-width: 360px; }
      }
    </style>
  </head>
  <body>
    <main>
      <div class="atas">
        <div class="atasbox">
          <amp-img class="imghero" height="500" width="500" layout="responsive" alt="banner"
          src="https://pub-400d5e420ec84b259d79304e5888a57e.r2.dev/fafa828-anti-rungkad.png">
        </amp-img>

        <div class="ataslink">
          <a href="https://fafa828.ink/" target="_blank" rel="nofollow">
            <div id="debar"><b>LOGIN</b></div>
          </a>
          <a href="https://jp.gaspolbosku.space/" target="_blank" rel="nofollow">
            <div id="debar"><b>DAFTAR</b></div>
          </a>
          <a href="https://tampan99.store/" target="_blank" rel="nofollow">
            <div id="debar"><b>LINK ALTERNATIF</b></div>
          </a>
        </div>
        <div class="footer">
          B$ - Copyright © 2025. All Rights Reserved.
        </div>
      </div>
    </div>
  </main>
</body>
</html>
<?php
} else {
  header("HTTP/1.0 404 Not Found");
  echo "404 Not Found";
}
?>